/***************************************************************************
                          cmrilib.h  -  header file for cmri library
                             -------------------
    begin                : Thu Jun 17 2004
    copyright            : (C) 2004 by Jason Nishiyama
    email                : evilscientist@shaw.ca
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <errno.h>
#include <termios.h>
#include <signal.h>
#include <sys/time.h>


/* Error codes */

#define NO_ERROR			0
#define UNSPECIFIED_ERROR		1
#define INVALID_NODE_DESCRIPTOR		10
#define INVALID_NODE_NUMBER		11
#define	INVALID_NUMBER_OUTPORT		12
#define	INVALID_NUMBER_INPORT		13
#define	ILLEGAL_SIGNAL_VALUE		14
#define SIGNAL_NUMBER_MISMATCH		15
#define TOO_MANY_CARDS			16
#define NOT_ENOUGH_CARDS		17
#define INVALID_CARD_VALUE		18
#define INVALID_PORT_NUMBER		19
#define INVALID_SERIAL_PORT		30
#define INVALID_BAUD_RATE		31
#define UNABLE_TO_OPEN_PORT		32
#define SERIAL_WRITE_ERROR		33
#define SERIAL_READ_TIMEOUT		34
#define SERIAL_READ_FRAME_ERROR		35
#define SERIAL_PORT_NOT_OPEN		36



/*cmri baud rate definitions*/

#define CMRI_B9600	0
#define CMRI_B19200	1
#define CMRI_B57600	2
#define CMRI_B115200	3

/*cmri com port definitions */

/* for those of you used to dos*/

#define CMRI_COM1		0
#define CMRI_COM2		1
#define CMRI_COM3		2
#define CMRI_COM4		3

/* for the rest of us*/

#define CMRI_TTYS0	0
#define CMRI_TTYS1	1
#define CMRI_TTYS2	2
#define CMRI_TTYS3	3

/* for usb to rs232 converters */

#define CMRI_USB0	10
#define CMRI_USB1	11
#define CMRI_USB2	12

/* legal combination of 2 lead signals on 8 bit ports */
unsigned char cmri_leg_sig[]={0,3,6,12,24,48,96,192,15,27,51,99,195,30,
				54,102,198,60,108,204,120,216,240,63,123,
				243,111,207,219,126,222,246,252,255};

/*legal combination of card type definitions for SUSIC/USIC cards*/								
unsigned char cmri_leg_card[]={2,1,10,6,9,5,42,26,38,22,41,25,37,21,170,
				106,154,90,166,102,150,86,169,105,153,89,
				165,101,149,85};


													
/* baud rates from definitions in termios.h */

int cmri_baud[]={B9600,B19200,B57600,B115200};

/* variables to operate the serial port
	Yes I know I'm going to burn in C hell for using a global...
*/
int cmri_sport_id=-1;   /* integer handle for serial port, set to error */

int cmri_timeout_sig=0; /* flag for the signal handler to set for timeout operations*/


 /* function prototypes */
int cmri_make_initialize (char cardtype, int nn, unsigned int dl, int ni, int no, int ns, int *ct);
int cmri_make_transmit(int nn, int no, int *ct);
int cmri_make_poll(int nn);
int cmri_createsendstring (char *in, int lin, char *out, int *lout);
int cmri_countsigs(char c);
int cmri_countports(char c);
int cmri_printstring(char *s, int slen, char otype);
int cmri_txdata(char *s, int slen);
int cmri_rxdata(char *, int *slen, int tout);
int cmri_open_serial_port(int port, int baud);
void cmri_sighandler(int sig);
int cmri_filltime(struct itimerval *value,int val_sec, int val_usec, int int_sec, int int_usec);
int cmri_getbyte(char *c, int tout);
